document.addEventListener('DOMContentLoaded', function() {
    const notificationToggle = document.getElementById('notificationToggle');
    const profileToggle = document.getElementById('profileToggle');
    const notificationContainer = document.getElementById('notificationContainer');
    const profileContainer = document.getElementById('profileContainer');

    notificationToggle.addEventListener('click', function() {
        if (notificationContainer.style.marginTop === '10px') {
            notificationContainer.style.marginTop = '-500px';
        } else {
            notificationContainer.style.marginTop = '10px';
        }
    });

    profileToggle.addEventListener('click', function() {
        if (profileContainer.style.marginTop === '10px') {
            profileContainer.style.marginTop = '-500px';
        } else {
            profileContainer.style.marginTop = '10px';
        }
    });
});



// for pagnation function
const pages = document.querySelectorAll('.page');
const prevBtn = document.getElementById('prev');
const nextBtn = document.getElementById('next');
let currentPage = 1;

function updatePagination() {
    pages.forEach(page => page.classList.remove('active'));
    pages[currentPage - 1].classList.add('active');
    prevBtn.disabled = currentPage === 1;
    nextBtn.disabled = currentPage === pages.length;
}

pages.forEach((page, index) => {
    page.addEventListener('click', () => {
        currentPage = index + 1;
        updatePagination();
    });
});

prevBtn.addEventListener('click', () => {
    if (currentPage > 1) {
        currentPage--;
        updatePagination();
    }
});

nextBtn.addEventListener('click', () => {
    if (currentPage < pages.length) {
        currentPage++;
        updatePagination();
    }
});